#define WLAN_SUPPORT        // if WiFi *not* used: add 2x slash in at beginning of line: //
#define ALARM_SUPPORT       // Support alert. if not desired: comment out with // at beginning

#ifdef WLAN_SUPPORT
  const char* ssid = "abc";            // enter your own SSID of Router
  const char* password = "abc";        // enter your own WiFi password
  String APIKey = "123";               // enter your own API-Key Thing Speak
#endif


//####### SPECIAL CONFIG ### normally no need to edit ########################################################################################################

// CO2-concentration
// <800 perfect                                               => green
const uint16_t LEVEL1 = 800;      // > 800 ppm: acceptable    => green+yellow
const uint16_t LEVEL2 = 1000;     // noticeable               => yellow
const uint16_t LEVEL3 = 1400;     // bad                      => yellow+red
const uint16_t LEVEL4 = 2000;     // unacceptable             => red + Alarm Buzzer

// GPIO usage. Do not use D4/GPIO2 (LED_BUILTIN), TX, RX and D5 (blue WiFi-LED), D3 GPIO0 Low @ start, aktivated Firmware-Upload, incl. 10 kΩ Pull-Up resistir, flashes on boot
// GPIO16=D0 free
const uint8_t LEDred = 12;    // GPIO12 = D6
const uint8_t LEDylw = 13;    // GPIO13 = D7
const uint8_t LEDgrn = 15;    // GPIO15 = D8
const uint8_t BUZZER = 14;    // GPIO14 = D5      
const uint8_t RxD = 4;        // GPIO4 = D2          ESP receive data (=TxD of MH-Z19C), software serial
const uint8_t TxD = 5;        // GPIO5 = D1          ESP send data (=RxD of MH-Z19C), software serial

const uint8_t tInterval = 30;      // measuring interval in seconds: 30, every 2nd time data will be send via WiFi
String ThingSpeakURL = "http://api.thingspeak.com/update?api_key=";         // API-access URL (no changes needed)
//#define DEBUG             // print debug infos over serial port. normally comment out
 
